/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.pa.problem;

import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemFilter;
import com.ibm.hwmca.fw.util.Trace;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TimeProblemFilter
implements ProblemFilter {
    private static final String TRACE_MASKT = "XPATMPFT";
    private static final String TRACE_MASKF = "XPATMPFF";
    private static final String TRACE_MASKD = "XPATMPFD";
    private long _filterTime = 30000L;
    private Problem referenceProblem;

    public TimeProblemFilter() {
        Trace.trace(TRACE_MASKD, "TimeProblemFilter ctor");
    }

    public TimeProblemFilter(long time) {
        Trace.trace(TRACE_MASKD, "TimeProblemFilter ctor(" + time + ")");
        this._filterTime = time;
    }

    public void filter(List theReturnList, List theProblems) {
        if (theReturnList == null) {
            theReturnList = new ArrayList<Problem>();
        }
        if (theProblems == null) {
            return;
        }
        Iterator inList = theProblems.iterator();
        while (inList.hasNext()) {
            Problem element = (Problem)inList.next();
            long currentTime = System.currentTimeMillis();
            long problemTime = element.getProblemTimeStamp();
            if (problemTime >= currentTime || problemTime <= currentTime - this._filterTime) continue;
            Trace.trace(TRACE_MASKD, "add the element");
            theReturnList.add(element);
        }
        Trace.trace(TRACE_MASKD, "returning " + theReturnList.size() + " elements");
    }

    public void setProblem(Problem theProblem) {
        this.referenceProblem = theProblem;
    }

    public Problem getProblem() {
        return this.referenceProblem;
    }
}

